/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.navigator.NavigatorItemInfo;
import com.equestricraft.mod.client.gui.navigator.NavigatorMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundNavigatorOpenPacket {
    private final List<NavigatorItemInfo> items;

    public ClientBoundNavigatorOpenPacket(List<NavigatorItemInfo> items) {
        this.items = items;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.items.size());
        for (NavigatorItemInfo item : this.items) {
            buffer.m_130077_(item.id());
            buffer.m_130070_(item.name());
            buffer.m_130070_(item.description());
        }
    }

    public static ClientBoundNavigatorOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<NavigatorItemInfo> items = new ArrayList<NavigatorItemInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            UUID id = buffer.m_130259_();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            NavigatorItemInfo item = new NavigatorItemInfo(id, name, description);
            items.add(item);
        }
        return new ClientBoundNavigatorOpenPacket(items);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> NavigatorMenuScreen.showScreen(this.items));
    }
}

