/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.gui.nickname.NicknameBuilderScreen;
import com.equestricraft.mod.nickname.NicknameChangeRequest;
import com.equestricraft.mod.nickname.NicknameSerializer;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundNicknameBuilderOpenPacket {
    private final boolean canUseFormattingCodes;
    private final NicknameChangeRequest existingRequest;

    public ClientBoundNicknameBuilderOpenPacket(boolean canUseFormattingCodes, NicknameChangeRequest existingRequest) {
        this.canUseFormattingCodes = canUseFormattingCodes;
        this.existingRequest = existingRequest;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.canUseFormattingCodes);
        NicknameSerializer.serializeNicknameChangeRequest(this.existingRequest, buffer);
    }

    public static ClientBoundNicknameBuilderOpenPacket decode(FriendlyByteBuf buffer) {
        boolean canUseFormattingCodes = buffer.readBoolean();
        NicknameChangeRequest existingRequest = NicknameSerializer.deserializeNicknameChangeRequest(buffer);
        return new ClientBoundNicknameBuilderOpenPacket(canUseFormattingCodes, existingRequest);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> NicknameBuilderScreen.showScreen(this.canUseFormattingCodes, this.existingRequest));
    }
}

