/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.ClientPrompt;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundNumberPromptOpenPacket {
    private final UUID uuid;
    private final String title;
    private final String text;
    private final Integer minimumValue;
    private final Integer maximumValue;
    private final Integer decimalPoints;

    public ClientBoundNumberPromptOpenPacket(UUID uuid, String title, String text, Integer minimumValue, Integer maximumValue, Integer decimalPoints) {
        this.uuid = uuid;
        this.title = title;
        this.text = text;
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.decimalPoints = decimalPoints;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130070_(this.title);
        buffer.m_130070_(this.text);
        if (this.minimumValue != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.minimumValue.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.maximumValue != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.maximumValue.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.decimalPoints != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.decimalPoints.intValue());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundNumberPromptOpenPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        String title = buffer.m_130277_();
        String text = buffer.m_130277_();
        Integer minimumValue = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        Integer maximumValue = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        Integer decimalPoints = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        return new ClientBoundNumberPromptOpenPacket(uuid, title, text, minimumValue, maximumValue, decimalPoints);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ClientPrompt.showNumberPrompt(this.uuid, this.title, this.text, this.minimumValue, this.maximumValue, this.decimalPoints));
    }
}

