/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.operation.OperationToolItemInfo;
import com.equestricraft.core.operation.OperationToolPage;
import com.equestricraft.mod.client.gui.operation.OperationToolboxMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundOperationToolboxPacket {
    private final OperationToolPage page;

    public ClientBoundOperationToolboxPacket(OperationToolPage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (OperationToolItemInfo operationItem : this.page.getItems()) {
            buffer.writeInt(operationItem.id());
            buffer.m_130070_(operationItem.name());
            buffer.m_130070_(operationItem.description());
            buffer.writeInt(operationItem.horses());
            buffer.m_130070_(operationItem.priceForPlayer());
            buffer.m_130070_(operationItem.paymentToUser());
            buffer.writeBoolean(operationItem.priceMayVary());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
    }

    public static ClientBoundOperationToolboxPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<OperationToolItemInfo> items = new ArrayList<OperationToolItemInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            int horses = buffer.readInt();
            String priceForPlayer = buffer.m_130277_();
            String paymentToUser = buffer.m_130277_();
            boolean priceMayVary = buffer.readBoolean();
            OperationToolItemInfo item = new OperationToolItemInfo(id, name, description, horses, priceForPlayer, paymentToUser, priceMayVary);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        OperationToolPage page = new OperationToolPage((List<OperationToolItemInfo>)items, pageNumber, totalPages, SortDirection.ASCENDING, (Object)null, (Object)null);
        return new ClientBoundOperationToolboxPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> OperationToolboxMenuScreen.showScreen(this.page));
    }
}

