/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.approval.PendingApprovalItem;
import com.equestricraft.mod.client.gui.approval.PendingApprovalMenu;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPendingApprovalsMenuOpenPacket {
    private final List<PendingApprovalItem> items;

    public ClientBoundPendingApprovalsMenuOpenPacket(List<PendingApprovalItem> items) {
        this.items = items;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.items.size());
        for (PendingApprovalItem item : this.items) {
            buffer.m_130077_(item.uuid());
            buffer.m_130070_(item.message());
            PlayerSerializer.serializePlayerSimple(item.fromPlayer(), buffer);
            buffer.m_130070_(item.durationDisplay());
        }
    }

    public static ClientBoundPendingApprovalsMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<PendingApprovalItem> items = new ArrayList<PendingApprovalItem>(amount);
        for (int i = 0; i < amount; ++i) {
            UUID uuid = buffer.m_130259_();
            String message = buffer.m_130277_();
            PlayerSimple fromPlayer = PlayerSerializer.deserializePlayerSimple(buffer);
            String durationDisplay = buffer.m_130277_();
            PendingApprovalItem item = new PendingApprovalItem(uuid, message, fromPlayer, durationDisplay);
            items.add(item);
        }
        return new ClientBoundPendingApprovalsMenuOpenPacket(items);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PendingApprovalMenu.showScreen(this.items));
    }
}

