/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.gui.PlayerAchievementScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.achievement.PlayerAchievementInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerAchievementMenuOpenPacket {
    private final List<PlayerAchievementInfo> achievements;

    public ClientBoundPlayerAchievementMenuOpenPacket(List<PlayerAchievementInfo> achievements) {
        this.achievements = achievements;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.achievements.size());
        for (PlayerAchievementInfo achievement : this.achievements) {
            buffer.m_130070_(achievement.name());
            buffer.m_130070_(achievement.description());
            buffer.writeInt(achievement.xpReward());
            buffer.writeDouble(achievement.percentageCompletion());
            buffer.writeBoolean(achievement.completed());
        }
    }

    public static ClientBoundPlayerAchievementMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<PlayerAchievementInfo> achievements = new ArrayList<PlayerAchievementInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            int xpReward = buffer.readInt();
            double percentageCompletion = buffer.readDouble();
            boolean complete = buffer.readBoolean();
            PlayerAchievementInfo achievement = new PlayerAchievementInfo(name, description, xpReward, percentageCompletion, complete);
            achievements.add(achievement);
        }
        return new ClientBoundPlayerAchievementMenuOpenPacket(achievements);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlayerAchievementScreen.showScreen(this.achievements));
    }
}

