/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.DegreeClassification;
import com.equestricraft.core.player.university.degree.PlayerDegreeInfoDto;
import com.equestricraft.mod.client.gui.university.UniversityDegreesScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerDegreeInfoListPacket {
    private final List<PlayerDegreeInfoDto> playerDegreeInfoList;

    public ClientBoundPlayerDegreeInfoListPacket(List<PlayerDegreeInfoDto> playerDegreeInfoList) {
        this.playerDegreeInfoList = playerDegreeInfoList;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.playerDegreeInfoList.size());
        for (PlayerDegreeInfoDto info2 : this.playerDegreeInfoList) {
            buffer.writeInt(info2.degreeId());
            buffer.m_130070_(info2.degreeName());
            if (info2.startedDate() == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.m_130075_(info2.startedDate());
            }
            if (info2.finishedDate() == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.m_130075_(info2.finishedDate());
            }
            if (info2.classification() == null) {
                buffer.writeBoolean(false);
                continue;
            }
            buffer.writeBoolean(true);
            buffer.m_130068_((Enum)info2.classification());
        }
    }

    public static ClientBoundPlayerDegreeInfoListPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<PlayerDegreeInfoDto> infoList = new ArrayList<PlayerDegreeInfoDto>(amount);
        for (int i = 0; i < amount; ++i) {
            int degreeId = buffer.readInt();
            String degreeName = buffer.m_130277_();
            Date startedDate = null;
            if (buffer.readBoolean()) {
                startedDate = buffer.m_130282_();
            }
            Date finishedDate = null;
            if (buffer.readBoolean()) {
                finishedDate = buffer.m_130282_();
            }
            DegreeClassification classification = null;
            if (buffer.readBoolean()) {
                classification = (DegreeClassification)buffer.m_130066_(DegreeClassification.class);
            }
            infoList.add(new PlayerDegreeInfoDto(degreeId, degreeName, startedDate, finishedDate, classification));
        }
        return new ClientBoundPlayerDegreeInfoListPacket(infoList);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> UniversityDegreesScreen.showScreen(this.playerDegreeInfoList));
    }
}

