/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.item.ECItemType;
import com.equestricraft.mod.client.gui.inventory.PlayerInventoryScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.inventory.PlayerInventoryListItem;
import com.equestricraft.mod.player.inventory.PlayerInventoryPage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerInventoryMenuOpenPacket {
    private final PlayerInventoryPage page;

    public ClientBoundPlayerInventoryMenuOpenPacket(PlayerInventoryPage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (PlayerInventoryListItem item : this.page.getItems()) {
            buffer.m_130068_((Enum)item.type());
            buffer.writeInt(item.itemId());
            buffer.m_130070_(item.itemName());
            buffer.m_130070_(item.itemDescription());
            buffer.writeDouble(item.itemQuantity());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
    }

    public static ClientBoundPlayerInventoryMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<PlayerInventoryListItem> items = new ArrayList<PlayerInventoryListItem>(amount);
        for (int i = 0; i < amount; ++i) {
            ECItemType type = (ECItemType)buffer.m_130066_(ECItemType.class);
            int itemId = buffer.readInt();
            String itemName = buffer.m_130277_();
            String itemDescription = buffer.m_130277_();
            double itemQuantity = buffer.readDouble();
            PlayerInventoryListItem item = new PlayerInventoryListItem(type, itemId, itemName, itemDescription, itemQuantity);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        PlayerInventoryPage page = new PlayerInventoryPage((List<PlayerInventoryListItem>)items, pageNumber, totalPages, SortDirection.ASCENDING, (Object)null, (Object)null);
        return new ClientBoundPlayerInventoryMenuOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlayerInventoryScreen.showScreen(this.page));
    }
}

