/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.medicine.MedicineInfo;
import com.equestricraft.core.player.medicine.MedicineInventoryItemInfo;
import com.equestricraft.mod.client.gui.medicine.PlayerMedicineInventoryMenu;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerMedicineListOpenPacket {
    private final int horseId;
    private final List<MedicineInventoryItemInfo> medicines;

    public ClientBoundPlayerMedicineListOpenPacket(int horseId, List<MedicineInventoryItemInfo> medicines) {
        this.horseId = horseId;
        this.medicines = medicines;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.medicines.size());
        for (MedicineInventoryItemInfo medicine : this.medicines) {
            buffer.writeInt(medicine.medicine().id());
            buffer.m_130070_(medicine.medicine().name());
            buffer.m_130070_(medicine.medicine().description());
            buffer.writeInt(medicine.quantity());
        }
    }

    public static ClientBoundPlayerMedicineListOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int amount = buffer.readInt();
        ArrayList<MedicineInventoryItemInfo> medicines = new ArrayList<MedicineInventoryItemInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            MedicineInfo info2 = new MedicineInfo(id, name, description);
            int quantity = buffer.readInt();
            MedicineInventoryItemInfo item = new MedicineInventoryItemInfo(info2, quantity);
            medicines.add(item);
        }
        return new ClientBoundPlayerMedicineListOpenPacket(horseId, medicines);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlayerMedicineInventoryMenu.showScreen(this.horseId, this.medicines));
    }
}

