/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.player.notification.PlayerNotificationPage;
import com.equestricraft.core.player.notification.PlayerNotificationRecord;
import com.equestricraft.mod.client.gui.notification.PlayerNotificationMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerNotificationMenuOpenPacket {
    private final PlayerNotificationPage page;

    public ClientBoundPlayerNotificationMenuOpenPacket(PlayerNotificationPage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (PlayerNotificationRecord item : this.page.getItems()) {
            buffer.m_130077_(item.notificationId());
            buffer.writeInt(item.hoursSince());
            buffer.m_130070_(item.message());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
        buffer.m_130070_((String)this.page.getFilterObject());
    }

    public static ClientBoundPlayerNotificationMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ArrayList<PlayerNotificationRecord> items = new ArrayList<PlayerNotificationRecord>(count);
        for (int i = 0; i < count; ++i) {
            UUID notificationId = buffer.m_130259_();
            int daysSince = buffer.readInt();
            String message = buffer.m_130277_();
            PlayerNotificationRecord item = new PlayerNotificationRecord(notificationId, daysSince, message);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        String textSearch = buffer.m_130277_();
        PlayerNotificationPage page = new PlayerNotificationPage((List<PlayerNotificationRecord>)items, pageNumber, totalPages, sortDirection, (Object)null, textSearch);
        return new ClientBoundPlayerNotificationMenuOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlayerNotificationMenuScreen.showScreen(this.page));
    }
}

