/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.Argb;
import com.equestricraft.common.DonatorLevel;
import com.equestricraft.common.RideStyle;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.player.profile.PlayerProfileInfo;
import com.equestricraft.mod.client.gui.PlayerProfileScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerProfileScreenOpenPacket {
    private final PlayerProfileInfo playerProfileInfo;

    public ClientBoundPlayerProfileScreenOpenPacket(PlayerProfileInfo playerProfileInfo) {
        this.playerProfileInfo = playerProfileInfo;
    }

    public void encode(FriendlyByteBuf buffer) {
        PlayerSerializer.serializePlayerSimple(this.playerProfileInfo.player(), buffer);
        buffer.m_130070_(this.playerProfileInfo.joinDate());
        buffer.writeBoolean(this.playerProfileInfo.onlineNow());
        if (this.playerProfileInfo.lastSeen() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.playerProfileInfo.lastSeen());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.playerProfileInfo.xp());
        buffer.m_130070_(this.playerProfileInfo.rank());
        buffer.writeInt(this.playerProfileInfo.rankColor().getIntValue());
        if (this.playerProfileInfo.job() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.playerProfileInfo.job());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.playerProfileInfo.universityHouse() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.playerProfileInfo.universityHouse());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.playerProfileInfo.club() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.playerProfileInfo.club());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.playerProfileInfo.horseCount());
        if (this.playerProfileInfo.rideStylePreference() != null) {
            buffer.writeBoolean(true);
            buffer.m_130068_((Enum)this.playerProfileInfo.rideStylePreference());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeBoolean(this.playerProfileInfo.donator());
        if (this.playerProfileInfo.donatorLevel() != null) {
            buffer.writeBoolean(true);
            buffer.m_130068_((Enum)this.playerProfileInfo.donatorLevel());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundPlayerProfileScreenOpenPacket decode(FriendlyByteBuf buffer) {
        PlayerSimple player = PlayerSerializer.deserializePlayerSimple(buffer);
        String joinDate = buffer.m_130277_();
        boolean onlineNow = buffer.readBoolean();
        String lastSeen = buffer.readBoolean() ? buffer.m_130277_() : null;
        int xp = buffer.readInt();
        String rank = buffer.m_130277_();
        int rankColor = buffer.readInt();
        String job = buffer.readBoolean() ? buffer.m_130277_() : null;
        String universityHouse = buffer.readBoolean() ? buffer.m_130277_() : null;
        String club = buffer.readBoolean() ? buffer.m_130277_() : null;
        int horseCount = buffer.readInt();
        RideStyle rideStylePreference = buffer.readBoolean() ? (RideStyle)buffer.m_130066_(RideStyle.class) : null;
        boolean donator = buffer.readBoolean();
        DonatorLevel donatorLevel = buffer.readBoolean() ? (DonatorLevel)buffer.m_130066_(DonatorLevel.class) : null;
        PlayerProfileInfo profile = new PlayerProfileInfo(player, joinDate, onlineNow, lastSeen, xp, rank, Argb.fromIntValue(rankColor), job, universityHouse, club, horseCount, rideStylePreference, donator, donatorLevel);
        return new ClientBoundPlayerProfileScreenOpenPacket(profile);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlayerProfileScreen.showScreen(this.playerProfileInfo));
    }
}

