/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.player.progression.PlayerProgressionMilestoneInfo;
import com.equestricraft.mod.client.gui.PlayerProgressionScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerProgressionMenuOpenPacket {
    private final int playerId;
    private final int playerXp;
    private final List<PlayerProgressionMilestoneInfo> milestones;

    public ClientBoundPlayerProgressionMenuOpenPacket(int playerId, int playerXp, List<PlayerProgressionMilestoneInfo> milestones) {
        this.playerId = playerId;
        this.playerXp = playerXp;
        this.milestones = milestones;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.playerId);
        buffer.writeInt(this.playerXp);
        buffer.writeInt(this.milestones.size());
        for (PlayerProgressionMilestoneInfo milestone : this.milestones) {
            buffer.m_130070_(milestone.name());
            buffer.m_130070_(milestone.group());
            buffer.writeInt(milestone.xpRequired());
            buffer.writeBoolean(milestone.unlocked());
            buffer.writeBoolean(milestone.announce());
        }
    }

    public static ClientBoundPlayerProgressionMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        int playerXp = buffer.readInt();
        int milestoneCount = buffer.readInt();
        ArrayList<PlayerProgressionMilestoneInfo> milestones = new ArrayList<PlayerProgressionMilestoneInfo>(milestoneCount);
        for (int i = 0; i < milestoneCount; ++i) {
            String name = buffer.m_130277_();
            String group = buffer.m_130277_();
            int xpRequired = buffer.readInt();
            boolean unlocked = buffer.readBoolean();
            boolean announce = buffer.readBoolean();
            PlayerProgressionMilestoneInfo milestone = new PlayerProgressionMilestoneInfo(name, group, xpRequired, unlocked, announce);
            milestones.add(milestone);
        }
        return new ClientBoundPlayerProgressionMenuOpenPacket(playerId, playerXp, milestones);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlayerProgressionScreen.showScreen(this.playerId, this.playerXp, this.milestones));
    }
}

