/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.playersearch.PlayerSearchMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import com.equestricraft.mod.player.search.PlayerSearchItem;
import com.equestricraft.mod.player.search.PlayerSearchPage;
import com.equestricraft.mod.player.search.PlayerSearchRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerSearchMenuOpenPacket {
    private final UUID uuid;
    private final PlayerSearchPage page;

    public ClientBoundPlayerSearchMenuOpenPacket(UUID uuid, PlayerSearchPage page) {
        this.uuid = uuid;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.writeInt(this.page.getItems().size());
        for (PlayerSearchItem playerItem : this.page.getItems()) {
            PlayerSerializer.serializePlayerSimple(playerItem.player(), buffer);
            buffer.writeBoolean(playerItem.starredBySearchingPlayer());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
        buffer.m_130070_(((PlayerSearchRequest)this.page.getFilterObject()).searchText());
        buffer.writeBoolean(((PlayerSearchRequest)this.page.getFilterObject()).mustBeOnline());
        buffer.writeBoolean(((PlayerSearchRequest)this.page.getFilterObject()).mustBeStarred());
    }

    public static ClientBoundPlayerSearchMenuOpenPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        int count = buffer.readInt();
        ArrayList<PlayerSearchItem> players = new ArrayList<PlayerSearchItem>(count);
        for (int i = 0; i < count; ++i) {
            PlayerSimple player = PlayerSerializer.deserializePlayerSimple(buffer);
            boolean starredBySearchingPlayer = buffer.readBoolean();
            PlayerSearchItem playerItem = new PlayerSearchItem(player, starredBySearchingPlayer);
            players.add(playerItem);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        String searchText = buffer.m_130277_();
        boolean mustBeOnline = buffer.readBoolean();
        boolean mustBeStarred = buffer.readBoolean();
        PlayerSearchRequest playerSearchRequest = new PlayerSearchRequest(searchText, mustBeOnline, mustBeStarred);
        PlayerSearchPage page = new PlayerSearchPage((List<PlayerSearchItem>)players, pageNumber, totalPages, sortDirection, (Object)null, playerSearchRequest);
        return new ClientBoundPlayerSearchMenuOpenPacket(uuid, page);
    }

    public boolean handler(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlayerSearchMenuScreen.showPlayerSearchMenuScreen(this.uuid, this.page));
    }
}

