/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.player.settings.PlayerSettingsDto;
import com.equestricraft.mod.client.gui.PlayerSettingsMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerSettingsMenuScreenOpenPacket {
    private final PlayerSettingsDto playerSettings;

    public ClientBoundPlayerSettingsMenuScreenOpenPacket(PlayerSettingsDto playerSettings) {
        this.playerSettings = playerSettings;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.playerSettings.hideChatDuringQuests().booleanValue());
        buffer.writeBoolean(this.playerSettings.showPlotMinimap().booleanValue());
    }

    public static ClientBoundPlayerSettingsMenuScreenOpenPacket decode(FriendlyByteBuf buffer) {
        boolean hideChatDuringQuests = buffer.readBoolean();
        boolean showPlotMinimap = buffer.readBoolean();
        PlayerSettingsDto playerSettings = new PlayerSettingsDto(hideChatDuringQuests, showPlotMinimap);
        return new ClientBoundPlayerSettingsMenuScreenOpenPacket(playerSettings);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlayerSettingsMenuScreen.showScreen(this.playerSettings));
    }
}

