/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.PlayerVisibilityController;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlayerVisibilityPacket {
    private final boolean hideOtherPlayers;

    public ClientBoundPlayerVisibilityPacket(boolean hideOtherPlayers) {
        this.hideOtherPlayers = hideOtherPlayers;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.hideOtherPlayers);
    }

    public static ClientBoundPlayerVisibilityPacket decode(FriendlyByteBuf buffer) {
        boolean hideOtherPlayers = buffer.readBoolean();
        return new ClientBoundPlayerVisibilityPacket(hideOtherPlayers);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlayerVisibilityController.setHideOtherPlayers(this.hideOtherPlayers));
    }
}

