/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.plot.access.PlotAccessInfo;
import com.equestricraft.core.plot.access.PlotAccessLevel;
import com.equestricraft.mod.client.gui.plot.PlotAccessListMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import com.equestricraft.mod.plot.PlotAccessPage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlotAccessMenuOpenPacket {
    private final int plotId;
    private final PlotAccessPage page;

    public ClientBoundPlotAccessMenuOpenPacket(int plotId, PlotAccessPage page) {
        this.plotId = plotId;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.plotId);
        buffer.writeInt(this.page.getItems().size());
        for (PlotAccessInfo item : this.page.getItems()) {
            PlayerSerializer.serializePlayerSimple(item.player(), buffer);
            buffer.m_130068_((Enum)item.accessLevel());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
    }

    public static ClientBoundPlotAccessMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int plotId = buffer.readInt();
        int amount = buffer.readInt();
        ArrayList<PlotAccessInfo> items = new ArrayList<PlotAccessInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            PlayerSimple player = PlayerSerializer.deserializePlayerSimple(buffer);
            PlotAccessLevel plotAccessLevel = (PlotAccessLevel)buffer.m_130066_(PlotAccessLevel.class);
            PlotAccessInfo item = new PlotAccessInfo(player, plotAccessLevel);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        PlotAccessPage page = new PlotAccessPage((List<PlotAccessInfo>)items, pageNumber, totalPages, SortDirection.ASCENDING, (Object)null, (Object)null);
        return new ClientBoundPlotAccessMenuOpenPacket(plotId, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlotAccessListMenuScreen.showScreen(this.plotId, this.page));
    }
}

