/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.plot.PlotInfo;
import com.equestricraft.mod.client.gui.plot.PlotListMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.plot.PlotPage;
import com.equestricraft.mod.plot.PlotSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlotListMenuOpenPacket {
    private final PlotPage page;

    public ClientBoundPlotListMenuOpenPacket(PlotPage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (PlotInfo plot : this.page.getItems()) {
            PlotSerializer.serialize(plot, buffer);
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
    }

    public static ClientBoundPlotListMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<PlotInfo> list = new ArrayList<PlotInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            PlotInfo plot = PlotSerializer.deserialize(buffer);
            list.add(plot);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        PlotPage page = new PlotPage((List<PlotInfo>)list, pageNumber, totalPages, SortDirection.ASCENDING, (Object)null, (Object)null);
        return new ClientBoundPlotListMenuOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlotListMenuScreen.showScreen(this.page));
    }
}

