/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.plot.PlotInfo;
import com.equestricraft.mod.client.gui.plot.PlotMergeScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.plot.PlotSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlotMergeMenuOpenPacket {
    private final PlotInfo targetPlot;
    private final List<PlotInfo> plots;

    public ClientBoundPlotMergeMenuOpenPacket(PlotInfo targetPlot, List<PlotInfo> plots) {
        this.targetPlot = targetPlot;
        this.plots = plots;
    }

    public void encode(FriendlyByteBuf buffer) {
        PlotSerializer.serialize(this.targetPlot, buffer);
        buffer.writeInt(this.plots.size());
        for (PlotInfo plot : this.plots) {
            PlotSerializer.serialize(plot, buffer);
        }
    }

    public static ClientBoundPlotMergeMenuOpenPacket decode(FriendlyByteBuf buffer) {
        PlotInfo targetPlot = PlotSerializer.deserialize(buffer);
        int amount = buffer.readInt();
        ArrayList<PlotInfo> plots = new ArrayList<PlotInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            PlotInfo plot = PlotSerializer.deserialize(buffer);
            plots.add(plot);
        }
        return new ClientBoundPlotMergeMenuOpenPacket(targetPlot, plots);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlotMergeScreen.showScreen(this.targetPlot, this.plots));
    }
}

