/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.core.plot.map.natural.PlotNaturalMapItem;
import com.equestricraft.mod.client.PlotMinimap;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlotMinimapUpdatePacket {
    private final List<PlotNaturalMapItem> items;

    public ClientBoundPlotMinimapUpdatePacket(List<PlotNaturalMapItem> items) {
        this.items = items;
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.items != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.items.size());
            for (PlotNaturalMapItem item : this.items) {
                buffer.writeInt(item.areas().size());
                for (Area2D area : item.areas()) {
                    buffer.writeInt(area.x1());
                    buffer.writeInt(area.x2());
                    buffer.writeInt(area.z1());
                    buffer.writeInt(area.z2());
                }
                buffer.m_130070_(item.name());
                buffer.writeBoolean(item.ownedByViewer());
                buffer.writeBoolean(item.accessibleByViewer());
            }
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundPlotMinimapUpdatePacket decode(FriendlyByteBuf buffer) {
        ArrayList<PlotNaturalMapItem> items = null;
        if (buffer.readBoolean()) {
            int itemsCount = buffer.readInt();
            items = new ArrayList<PlotNaturalMapItem>(itemsCount);
            for (int i = 0; i < itemsCount; ++i) {
                int areasCount = buffer.readInt();
                ArrayList<Area2D> areas = new ArrayList<Area2D>(areasCount);
                for (int j = 0; j < areasCount; ++j) {
                    int x1 = buffer.readInt();
                    int x2 = buffer.readInt();
                    int z1 = buffer.readInt();
                    int z2 = buffer.readInt();
                    Area2D area = new Area2D(x1, x2, z1, z2);
                    areas.add(area);
                }
                String name = buffer.m_130277_();
                boolean ownedByViewer = buffer.readBoolean();
                boolean accessibleByViewer = buffer.readBoolean();
                PlotNaturalMapItem item = new PlotNaturalMapItem(areas, name, ownedByViewer, accessibleByViewer);
                items.add(item);
            }
        }
        return new ClientBoundPlotMinimapUpdatePacket(items);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> {
            PlotMinimap minimap = PlotMinimap.getInstance();
            minimap.setPlotsToShow(this.items);
        });
    }
}

