/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.core.plot.PlotNearbyAreaMapItem;
import com.equestricraft.core.plot.PlotNearbyAreaType;
import com.equestricraft.mod.client.gui.plot.PlotNaturalPurchaseScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlotNearbyAreasUpdatePacket {
    private final List<PlotNearbyAreaMapItem> plotMapItems;

    public ClientBoundPlotNearbyAreasUpdatePacket(List<PlotNearbyAreaMapItem> plotMapItems) {
        this.plotMapItems = plotMapItems;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.plotMapItems.size());
        for (PlotNearbyAreaMapItem plotMapItem : this.plotMapItems) {
            buffer.writeInt(plotMapItem.areas().size());
            for (Area2D area : plotMapItem.areas()) {
                buffer.writeInt(area.x1());
                buffer.writeInt(area.x2());
                buffer.writeInt(area.z1());
                buffer.writeInt(area.z2());
            }
            buffer.m_130068_((Enum)plotMapItem.type());
            buffer.writeBoolean(plotMapItem.hasOverlap());
        }
    }

    public static ClientBoundPlotNearbyAreasUpdatePacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<PlotNearbyAreaMapItem> plotMapItems = new ArrayList<PlotNearbyAreaMapItem>(amount);
        for (int i = 0; i < amount; ++i) {
            int areasCount = buffer.readInt();
            ArrayList<Area2D> areas = new ArrayList<Area2D>(areasCount);
            for (int j = 0; j < areasCount; ++j) {
                int x1 = buffer.readInt();
                int x2 = buffer.readInt();
                int z1 = buffer.readInt();
                int z2 = buffer.readInt();
                Area2D area = new Area2D(x1, x2, z1, z2);
                areas.add(area);
            }
            PlotNearbyAreaType type = (PlotNearbyAreaType)buffer.m_130066_(PlotNearbyAreaType.class);
            boolean hasOverlap = buffer.readBoolean();
            PlotNearbyAreaMapItem item = new PlotNearbyAreaMapItem(areas, type, hasOverlap);
            plotMapItems.add(item);
        }
        return new ClientBoundPlotNearbyAreasUpdatePacket(plotMapItems);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        return PacketUtil.handleClientPacket(contextSupplier, () -> PlotNaturalPurchaseScreen.updateMap(this.plotMapItems));
    }
}

