/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.plot.PlotCoordinate;
import com.equestricraft.core.plot.map.PlotMapItemType;
import com.equestricraft.core.plot.map.grid.PlotGridMapItem;
import com.equestricraft.mod.client.gui.plot.PlotGridNearbyMapScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlotNearbyMapOpenPacket {
    private final List<PlotGridMapItem> items;

    public ClientBoundPlotNearbyMapOpenPacket(List<PlotGridMapItem> items) {
        this.items = items;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.items.size());
        for (PlotGridMapItem item : this.items) {
            buffer.writeInt(item.plotId());
            buffer.writeInt(item.coordinates().size());
            for (PlotCoordinate coordinate : item.coordinates()) {
                buffer.writeInt(coordinate.getX());
                buffer.writeInt(coordinate.getZ());
            }
            buffer.m_130068_((Enum)item.type());
        }
    }

    public static ClientBoundPlotNearbyMapOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<PlotGridMapItem> items = new ArrayList<PlotGridMapItem>(amount);
        for (int i = 0; i < amount; ++i) {
            int plotId = buffer.readInt();
            int coordinateCount = buffer.readInt();
            ArrayList<PlotCoordinate> coordinates = new ArrayList<PlotCoordinate>(coordinateCount);
            for (int j = 0; j < coordinateCount; ++j) {
                int x = buffer.readInt();
                int z = buffer.readInt();
                PlotCoordinate coordinate = new PlotCoordinate(x, z);
                coordinates.add(coordinate);
            }
            PlotMapItemType type = (PlotMapItemType)buffer.m_130066_(PlotMapItemType.class);
            PlotGridMapItem item = new PlotGridMapItem(plotId, coordinates, type);
            items.add(item);
        }
        return new ClientBoundPlotNearbyMapOpenPacket(items);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlotGridNearbyMapScreen.showScreen(this.items));
    }
}

