/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.plot.approval.PlotActionType;
import com.equestricraft.core.plot.approval.PlotPendingApprovalInfo;
import com.equestricraft.mod.client.gui.plot.PlotPendingApprovalsScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.plot.PlotPendingApprovalsPage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlotPendingApprovalsMenuOpenPacket {
    private final PlotPendingApprovalsPage page;

    public ClientBoundPlotPendingApprovalsMenuOpenPacket(PlotPendingApprovalsPage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (PlotPendingApprovalInfo item : this.page.getItems()) {
            buffer.m_130068_((Enum)item.actionType());
            buffer.writeInt(item.plotId());
            buffer.m_130070_(item.plotName());
            buffer.writeBoolean(item.approvalGiven());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundPlotPendingApprovalsMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ArrayList<PlotPendingApprovalInfo> items = new ArrayList<PlotPendingApprovalInfo>(count);
        for (int i = 0; i < count; ++i) {
            PlotActionType actionType = (PlotActionType)buffer.m_130066_(PlotActionType.class);
            int plotId = buffer.readInt();
            String plotName = buffer.m_130277_();
            boolean approvalGiven = buffer.readBoolean();
            PlotPendingApprovalInfo item = new PlotPendingApprovalInfo(actionType, plotId, plotName, approvalGiven);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        PlotPendingApprovalsPage page = new PlotPendingApprovalsPage((List<PlotPendingApprovalInfo>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundPlotPendingApprovalsMenuOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlotPendingApprovalsScreen.showScreen(this.page));
    }
}

