/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.client.gui.plot.PlotSellMenu;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import com.equestricraft.mod.plot.PlotSellInfo;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPlotSellMenuOpenPacket {
    private final PlotSellInfo info;

    public ClientBoundPlotSellMenuOpenPacket(PlotSellInfo info2) {
        this.info = info2;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.info.plotId());
        buffer.m_130070_(this.info.plotName());
        PlayerSerializer.serializePlayerSimple(this.info.toPlayer(), buffer);
    }

    public static ClientBoundPlotSellMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int plotId = buffer.readInt();
        String plotName = buffer.m_130277_();
        PlayerSimple player = PlayerSerializer.deserializePlayerSimple(buffer);
        PlotSellInfo info2 = new PlotSellInfo(plotId, plotName, player);
        return new ClientBoundPlotSellMenuOpenPacket(info2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PlotSellMenu.showScreen(this.info));
    }
}

