/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.gui.prescription.PrescriptionGiveMenu;
import com.equestricraft.mod.horse.prescription.PrescriptionMedicineItem;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPrescriptionGiveMenuOpenPacket {
    private final int horseId;
    private final String horseName;
    private final int illnessId;
    private final String illnessName;
    private final List<PrescriptionMedicineItem> medicineItems;

    public ClientBoundPrescriptionGiveMenuOpenPacket(int horseId, String horseName, int illnessId, String illnessName, List<PrescriptionMedicineItem> medicineItems) {
        this.horseId = horseId;
        this.horseName = horseName;
        this.illnessId = illnessId;
        this.illnessName = illnessName;
        this.medicineItems = medicineItems;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.m_130070_(this.horseName);
        buffer.writeInt(this.illnessId);
        buffer.m_130070_(this.illnessName);
        buffer.writeInt(this.medicineItems.size());
        for (PrescriptionMedicineItem item : this.medicineItems) {
            buffer.writeInt(item.medicineId());
            buffer.m_130070_(item.medicineName());
            buffer.m_130070_(item.medicineDescription());
            buffer.writeInt(item.dosageEffectivenessPercentage());
        }
    }

    public static ClientBoundPrescriptionGiveMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        String horseName = buffer.m_130277_();
        int illnessId = buffer.readInt();
        String illnessName = buffer.m_130277_();
        int medicineCount = buffer.readInt();
        ArrayList<PrescriptionMedicineItem> medicineItems = new ArrayList<PrescriptionMedicineItem>(medicineCount);
        for (int i = 0; i < medicineCount; ++i) {
            int medicineId = buffer.readInt();
            String medicineName = buffer.m_130277_();
            String medicineDescription = buffer.m_130277_();
            int percentage = buffer.readInt();
            PrescriptionMedicineItem item = new PrescriptionMedicineItem(medicineId, medicineName, medicineDescription, percentage);
            medicineItems.add(item);
        }
        return new ClientBoundPrescriptionGiveMenuOpenPacket(horseId, horseName, illnessId, illnessName, medicineItems);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PrescriptionGiveMenu.showScreen(this.horseId, this.horseName, this.illnessId, this.illnessName, this.medicineItems));
    }
}

