/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.horse.prescription.PrescriptionInfo;
import com.equestricraft.mod.client.gui.prescription.PrescriptionListMenu;
import com.equestricraft.mod.horse.prescription.HorsePrescriptionPage;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundPrescriptionListMenuOpenPacket {
    private final int horseId;
    private final HorsePrescriptionPage page;

    public ClientBoundPrescriptionListMenuOpenPacket(int horseId, HorsePrescriptionPage page) {
        this.horseId = horseId;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.page.getItems().size());
        for (PrescriptionInfo item : this.page.getItems()) {
            buffer.writeInt(item.id());
            buffer.writeInt(item.daysSinceGiven());
            buffer.m_130070_(item.description());
            buffer.writeInt(item.prescriptionMedicines().size());
            for (PrescriptionInfo.PrescriptionMedicine medicine : item.prescriptionMedicines()) {
                buffer.writeInt(medicine.medicineId());
                buffer.m_130070_(medicine.medicineName());
                buffer.writeInt(medicine.dosageAmount());
                buffer.m_130070_(medicine.dosageUnitName());
                buffer.writeInt(medicine.durationHours());
            }
        }
        buffer.m_130068_((Enum)this.page.getSortDirection());
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
    }

    public static ClientBoundPrescriptionListMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int amount = buffer.readInt();
        ArrayList<PrescriptionInfo> items = new ArrayList<PrescriptionInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            int id = buffer.readInt();
            int days = buffer.readInt();
            String description = buffer.m_130277_();
            int medicineAmount = buffer.readInt();
            ArrayList<PrescriptionInfo.PrescriptionMedicine> medicines = new ArrayList<PrescriptionInfo.PrescriptionMedicine>(medicineAmount);
            for (int j = 0; j < medicineAmount; ++j) {
                int medicineId = buffer.readInt();
                String medicineName = buffer.m_130277_();
                int dosageSize = buffer.readInt();
                String dosageUnitName = buffer.m_130277_();
                int durationHours = buffer.readInt();
                PrescriptionInfo.PrescriptionMedicine medicine = new PrescriptionInfo.PrescriptionMedicine(medicineId, medicineName, dosageSize, dosageUnitName, durationHours);
                medicines.add(medicine);
            }
            PrescriptionInfo info2 = new PrescriptionInfo(id, description, days, medicines);
            items.add(info2);
        }
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        HorsePrescriptionPage page = new HorsePrescriptionPage((List<PrescriptionInfo>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundPrescriptionListMenuOpenPacket(horseId, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> PrescriptionListMenu.showMenu(this.horseId, this.page));
    }
}

