/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.hud.ProgressBarHudElement;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.progressbar.ProgressBarInformation;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundProgressBarUpdatePacket {
    private final ProgressBarInformation progressBarInformation;

    public ClientBoundProgressBarUpdatePacket(ProgressBarInformation progressBarInformation) {
        this.progressBarInformation = progressBarInformation;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.progressBarInformation.xpChangeAmount());
        if (this.progressBarInformation.percentageThroughCurrentRank() != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.progressBarInformation.percentageThroughCurrentRank().intValue());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.progressBarInformation.rankColor().getIntValue());
    }

    public static ClientBoundProgressBarUpdatePacket decode(FriendlyByteBuf buffer) {
        int xpChangeAmount = buffer.readInt();
        Integer percentageThroughCurrentRank = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        Argb rankColor = Argb.fromIntValue(buffer.readInt());
        ProgressBarInformation info2 = new ProgressBarInformation(xpChangeAmount, percentageThroughCurrentRank, rankColor);
        return new ClientBoundProgressBarUpdatePacket(info2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ProgressBarHudElement.setProgressBarInformation(this.progressBarInformation));
    }
}

