/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.ECLevel;
import com.equestricraft.core.player.provision.PlayerProvisionItemInfo;
import com.equestricraft.mod.client.gui.provision.ProvisionInventoryMenu;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.provision.ProvisionInventoryPage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundProvisionInventoryMenuOpenPacket {
    private final ProvisionInventoryPage page;
    private final Integer horseId;
    private final int provisionId;
    private final String provisionName;
    private final Integer containerEntityId;
    private final ECLevel level;

    public ClientBoundProvisionInventoryMenuOpenPacket(ProvisionInventoryPage page, Integer horseId, int provisionId, String provisionName, Integer containerEntityId, ECLevel level) {
        this.page = page;
        this.horseId = horseId;
        this.provisionId = provisionId;
        this.provisionName = provisionName;
        this.containerEntityId = containerEntityId;
        this.level = level;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.page.getItems().size());
        for (PlayerProvisionItemInfo item : this.page.getItems()) {
            buffer.m_130077_(item.uuid());
            buffer.writeInt(item.provisionId());
            buffer.m_130070_(item.provisionName());
            buffer.m_130070_(item.provisionDescription());
            if (item.daysUntilExpiry() != null) {
                buffer.writeBoolean(true);
                buffer.writeInt(item.daysUntilExpiry().intValue());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.writeDouble(item.unitsRemaining());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        if (this.horseId != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.horseId.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.provisionId);
        buffer.m_130070_(this.provisionName);
        if (this.containerEntityId != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.containerEntityId.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.level != null) {
            buffer.writeBoolean(true);
            buffer.m_130068_((Enum)this.level);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundProvisionInventoryMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<PlayerProvisionItemInfo> items = new ArrayList<PlayerProvisionItemInfo>(amount);
        for (int i = 0; i < amount; ++i) {
            UUID uuid = buffer.m_130259_();
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            String description = buffer.m_130277_();
            Integer daysUntilExpiry = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
            double unitsRemaining = buffer.readDouble();
            PlayerProvisionItemInfo item = new PlayerProvisionItemInfo(uuid, id, name, description, daysUntilExpiry, unitsRemaining);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        ProvisionInventoryPage page = new ProvisionInventoryPage((List<PlayerProvisionItemInfo>)items, pageNumber, totalPages, SortDirection.ASCENDING, (Object)null, (Object)null);
        Integer horseId = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        int provisionId = buffer.readInt();
        String provisionName = buffer.m_130277_();
        Integer intoBucketCoordinate = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        ECLevel level = buffer.readBoolean() ? (ECLevel)buffer.m_130066_(ECLevel.class) : null;
        return new ClientBoundProvisionInventoryMenuOpenPacket(page, horseId, provisionId, provisionName, intoBucketCoordinate, level);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ProvisionInventoryMenu.showMenu(this.horseId, this.provisionId, this.provisionName, this.page, this.containerEntityId, this.level));
    }
}

