/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.player.provision.ProvisionTypeInventoryDetails;
import com.equestricraft.core.provision.ProvisionInfo;
import com.equestricraft.mod.client.gui.provision.ProvisionItemTypeListMenu;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.provision.ProvisionSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundProvisionItemListMenuOpenPacket {
    private final Integer horseId;
    private final Integer containerEntityId;
    private final List<ProvisionTypeInventoryDetails> provisions;

    public ClientBoundProvisionItemListMenuOpenPacket(Integer horseId, Integer containerEntityId, List<ProvisionTypeInventoryDetails> provisions) {
        this.horseId = horseId;
        this.containerEntityId = containerEntityId;
        this.provisions = provisions;
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.horseId != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.horseId.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.containerEntityId != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.containerEntityId.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeInt(this.provisions.size());
        for (ProvisionTypeInventoryDetails provision : this.provisions) {
            ProvisionSerializer.serializeProvisionInfo(provision.provision(), buffer);
            buffer.writeDouble(provision.quantity());
            buffer.writeDouble(provision.expiredQuantity());
        }
    }

    public static ClientBoundProvisionItemListMenuOpenPacket decode(FriendlyByteBuf buffer) {
        Integer horseId = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        Integer containerEntityId = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        int amount = buffer.readInt();
        ArrayList<ProvisionTypeInventoryDetails> provisions = new ArrayList<ProvisionTypeInventoryDetails>(amount);
        for (int i = 0; i < amount; ++i) {
            ProvisionInfo provision = ProvisionSerializer.deserializeProvisionInfo(buffer);
            double quantity = buffer.readDouble();
            double expiredQuantity = buffer.readDouble();
            ProvisionTypeInventoryDetails details = new ProvisionTypeInventoryDetails(provision, quantity, expiredQuantity);
            provisions.add(details);
        }
        return new ClientBoundProvisionItemListMenuOpenPacket(horseId, containerEntityId, provisions);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ProvisionItemTypeListMenu.showScreen(this.horseId, this.containerEntityId, this.provisions));
    }
}

