/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.quest.menu.QuestObjectiveMenuItem;
import com.equestricraft.core.quest.menu.QuestProgressMenuInfo;
import com.equestricraft.mod.client.gui.quest.CurrentQuestScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundQuestCurrentMenuOpenPacket {
    private final QuestProgressMenuInfo questProgressMenuInfo;

    public ClientBoundQuestCurrentMenuOpenPacket(QuestProgressMenuInfo questProgressMenuInfo) {
        this.questProgressMenuInfo = questProgressMenuInfo;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.questProgressMenuInfo.id());
        buffer.m_130070_(this.questProgressMenuInfo.name());
        buffer.m_130070_(this.questProgressMenuInfo.description());
        buffer.writeBoolean(this.questProgressMenuInfo.canPause());
        buffer.writeInt(this.questProgressMenuInfo.objectives().size());
        for (QuestObjectiveMenuItem item : this.questProgressMenuInfo.objectives()) {
            buffer.m_130077_(item.id());
            buffer.m_130070_(item.title());
            buffer.m_130070_(item.hint());
            buffer.writeBoolean(item.completed());
        }
    }

    public static ClientBoundQuestCurrentMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int questId = buffer.readInt();
        String questName = buffer.m_130277_();
        String questDescription = buffer.m_130277_();
        boolean canPause = buffer.readBoolean();
        int objectivesAmount = buffer.readInt();
        ArrayList<QuestObjectiveMenuItem> objectives = new ArrayList<QuestObjectiveMenuItem>(objectivesAmount);
        for (int i = 0; i < objectivesAmount; ++i) {
            UUID objectiveId = buffer.m_130259_();
            String title = buffer.m_130277_();
            String hint = buffer.m_130277_();
            boolean completed = buffer.readBoolean();
            QuestObjectiveMenuItem item = new QuestObjectiveMenuItem(objectiveId, title, hint, completed);
            objectives.add(item);
        }
        QuestProgressMenuInfo info2 = new QuestProgressMenuInfo(questId, questName, questDescription, canPause, objectives);
        return new ClientBoundQuestCurrentMenuOpenPacket(info2);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> CurrentQuestScreen.showScreen(this.questProgressMenuInfo));
    }
}

