/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.Argb;
import com.equestricraft.core.quest.TrackedQuestDisplayInformation;
import com.equestricraft.mod.client.hud.QuestHudElement;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundQuestInfoDisplayUpdatePacket {
    private final TrackedQuestDisplayInformation questDisplayInformation;

    public ClientBoundQuestInfoDisplayUpdatePacket(TrackedQuestDisplayInformation questDisplayInformation) {
        this.questDisplayInformation = questDisplayInformation;
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.questDisplayInformation != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.questDisplayInformation.questName());
            buffer.writeInt(this.questDisplayInformation.objectives().size());
            for (String objective : this.questDisplayInformation.objectives()) {
                buffer.m_130070_(objective);
            }
            buffer.writeLong(this.questDisplayInformation.updateTime().getTime());
            if (this.questDisplayInformation.timerEndTime() != null) {
                buffer.writeBoolean(true);
                buffer.writeLong(this.questDisplayInformation.timerEndTime().getTime());
            } else {
                buffer.writeBoolean(false);
            }
            if (this.questDisplayInformation.timerEndColor() != null) {
                buffer.writeBoolean(true);
                buffer.writeInt(this.questDisplayInformation.timerEndColor().getIntValue());
            } else {
                buffer.writeBoolean(false);
            }
            if (this.questDisplayInformation.stopwatchStartTime() != null) {
                buffer.writeBoolean(true);
                buffer.writeLong(this.questDisplayInformation.stopwatchStartTime().getTime());
            } else {
                buffer.writeBoolean(false);
            }
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundQuestInfoDisplayUpdatePacket decode(FriendlyByteBuf buffer) {
        TrackedQuestDisplayInformation questDisplayInformation = null;
        if (buffer.readBoolean()) {
            String questName = buffer.m_130277_();
            int objectivesCount = buffer.readInt();
            ArrayList<String> objectives = new ArrayList<String>(objectivesCount);
            for (int i = 0; i < objectivesCount; ++i) {
                String objective = buffer.m_130277_();
                objectives.add(objective);
            }
            Date updateTime = new Date(buffer.readLong());
            Date timerEndTime = buffer.readBoolean() ? new Date(buffer.readLong()) : null;
            Argb timerEndColor = buffer.readBoolean() ? Argb.fromIntValue(buffer.readInt()) : null;
            Date stopwatchStartTime = buffer.readBoolean() ? new Date(buffer.readLong()) : null;
            questDisplayInformation = new TrackedQuestDisplayInformation(questName, objectives, updateTime, timerEndTime, timerEndColor, stopwatchStartTime);
        }
        return new ClientBoundQuestInfoDisplayUpdatePacket(questDisplayInformation);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> QuestHudElement.setInfo(this.questDisplayInformation));
    }
}

