/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.QuestType;
import com.equestricraft.core.quest.menu.QuestMenuItem;
import com.equestricraft.core.quest.menu.QuestSingleMenuItem;
import com.equestricraft.core.quest.menu.QuestStoryGroupMenuItem;
import com.equestricraft.mod.client.gui.quest.QuestItemScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundQuestMenuItemListPacket {
    private final String menuTitle;
    private final QuestType questType;
    private final List<QuestMenuItem> questMenuItems;

    public ClientBoundQuestMenuItemListPacket(String menuTitle, QuestType questType, List<QuestMenuItem> questMenuItems) {
        this.menuTitle = menuTitle;
        this.questType = questType;
        this.questMenuItems = questMenuItems;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.menuTitle);
        buffer.m_130068_((Enum)this.questType);
        buffer.writeInt(this.questMenuItems.size());
        for (QuestMenuItem item : this.questMenuItems) {
            buffer.writeInt(item.getId());
            buffer.m_130070_(item.getTitle());
            buffer.m_130070_(item.getDescription());
            if (item instanceof QuestStoryGroupMenuItem) {
                QuestStoryGroupMenuItem questStoryGroupMenuItem = (QuestStoryGroupMenuItem)item;
                buffer.writeInt(1);
                if (questStoryGroupMenuItem.getCompletionPercentage() != null) {
                    buffer.writeBoolean(true);
                    buffer.writeDouble(questStoryGroupMenuItem.getCompletionPercentage().doubleValue());
                    continue;
                }
                buffer.writeBoolean(false);
                continue;
            }
            if (item instanceof QuestSingleMenuItem) {
                QuestSingleMenuItem questSingleMenuItem = (QuestSingleMenuItem)item;
                buffer.writeInt(2);
                buffer.writeBoolean(questSingleMenuItem.isCompleted());
                buffer.writeBoolean(questSingleMenuItem.isNotLive());
                if (questSingleMenuItem.getStartElementId() != null) {
                    buffer.writeBoolean(true);
                    buffer.m_130077_(questSingleMenuItem.getStartElementId());
                } else {
                    buffer.writeBoolean(false);
                }
                if (questSingleMenuItem.getMoneyReward() != null) {
                    buffer.writeBoolean(true);
                    buffer.m_130070_(questSingleMenuItem.getMoneyReward());
                } else {
                    buffer.writeBoolean(false);
                }
                buffer.writeInt(questSingleMenuItem.getXpReward());
                buffer.writeBoolean(questSingleMenuItem.isCanStart());
                continue;
            }
            throw new IllegalArgumentException(String.format("Invalid quest class: %s", item.getClass().getName()));
        }
    }

    public static ClientBoundQuestMenuItemListPacket decode(FriendlyByteBuf buffer) {
        String menuTitle = buffer.m_130277_();
        QuestType questType = (QuestType)buffer.m_130066_(QuestType.class);
        int amount = buffer.readInt();
        ArrayList<QuestMenuItem> items = new ArrayList<QuestMenuItem>(amount);
        for (int j = 0; j < amount; ++j) {
            int itemId = buffer.readInt();
            String itemTitle = buffer.m_130277_();
            String itemDescription = buffer.m_130277_();
            int itemType = buffer.readInt();
            if (itemType == 1) {
                Double completionPercentage = buffer.readBoolean() ? Double.valueOf(buffer.readDouble()) : null;
                QuestStoryGroupMenuItem groupItem = new QuestStoryGroupMenuItem(itemId, itemTitle, itemDescription, completionPercentage);
                items.add(groupItem);
                continue;
            }
            if (itemType == 2) {
                boolean completed = buffer.readBoolean();
                boolean notLive = buffer.readBoolean();
                UUID startElementId = buffer.readBoolean() ? buffer.m_130259_() : null;
                String moneyReward = buffer.readBoolean() ? buffer.m_130277_() : null;
                int xpReward = buffer.readInt();
                boolean canStart = buffer.readBoolean();
                QuestSingleMenuItem singleItem = new QuestSingleMenuItem(itemId, itemTitle, itemDescription, completed, notLive, startElementId, moneyReward, xpReward, canStart);
                items.add(singleItem);
                continue;
            }
            throw new IllegalArgumentException(String.format("Invalid item type: %s", itemType));
        }
        return new ClientBoundQuestMenuItemListPacket(menuTitle, questType, items);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> QuestItemScreen.showScreen(this.menuTitle, this.questType, this.questMenuItems));
    }
}

