/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.salesbarn.SalesBarnHorseInfo;
import com.equestricraft.mod.client.gui.SalesBarnHorseViewMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundSalesBarnHorseMenuPacket {
    private final SalesBarnHorseInfo info;
    private final long unlockTime;

    public ClientBoundSalesBarnHorseMenuPacket(SalesBarnHorseInfo info2, long unlockTime) {
        this.info = info2;
        this.unlockTime = unlockTime;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.info.stallId());
        buffer.m_130070_(this.info.gender());
        buffer.m_130070_(this.info.ageDisplay());
        buffer.m_130070_(this.info.price());
        buffer.writeLong(this.unlockTime);
    }

    public static ClientBoundSalesBarnHorseMenuPacket decode(FriendlyByteBuf buffer) {
        int stallId = buffer.readInt();
        String gender = buffer.m_130277_();
        String ageDisplay = buffer.m_130277_();
        String price = buffer.m_130277_();
        SalesBarnHorseInfo info2 = new SalesBarnHorseInfo(stallId, gender, ageDisplay, price);
        long unlockTime = buffer.readLong();
        return new ClientBoundSalesBarnHorseMenuPacket(info2, unlockTime);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> SalesBarnHorseViewMenuScreen.showScreen(this.info, this.unlockTime));
    }
}

