/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.ScreenFade;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundScreenFadePacket {
    private final long fadeInDuration;
    private final long stayDuration;
    private final long fadeOutDuration;
    private final Argb color;

    public ClientBoundScreenFadePacket(long fadeInDuration, long stayDuration, long fadeOutDuration, Argb color) {
        this.fadeInDuration = fadeInDuration;
        this.stayDuration = stayDuration;
        this.fadeOutDuration = fadeOutDuration;
        this.color = color;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.fadeInDuration);
        buffer.writeLong(this.stayDuration);
        buffer.writeLong(this.fadeOutDuration);
        buffer.writeInt(this.color.getIntValue());
    }

    public static ClientBoundScreenFadePacket decode(FriendlyByteBuf buffer) {
        long fadeInDuration = buffer.readLong();
        long stayDuration = buffer.readLong();
        long fadeOutDuration = buffer.readLong();
        Argb color = Argb.fromIntValue(buffer.readInt());
        return new ClientBoundScreenFadePacket(fadeInDuration, stayDuration, fadeOutDuration, color);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ScreenFade.setScreenFade(this.fadeInDuration, this.stayDuration, this.fadeInDuration, this.color));
    }
}

