/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.gui.ServerRulesMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundServerRuleMenuPacket {
    private final List<String> rules;
    private final boolean hasAgreed;

    public ClientBoundServerRuleMenuPacket(List<String> rules, boolean hasAgreed) {
        this.rules = rules;
        this.hasAgreed = hasAgreed;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.rules.size());
        this.rules.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
        buffer.writeBoolean(this.hasAgreed);
    }

    public static ClientBoundServerRuleMenuPacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<String> rules = new ArrayList<String>(amount);
        for (int i = 0; i < amount; ++i) {
            rules.add(buffer.m_130277_());
        }
        boolean hasAgreed = buffer.readBoolean();
        return new ClientBoundServerRuleMenuPacket(rules, hasAgreed);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ServerRulesMenuScreen.showScreen(this.rules, this.hasAgreed));
    }
}

