/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.shop.ShopInfo;
import com.equestricraft.core.shop.item.ShopItemInfo;
import com.equestricraft.mod.client.gui.shop.ShopItemMenuScreen;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundShopMenuOpenPacket {
    private final ShopInfo shop;
    private final List<ShopItemInfo> items;

    public ClientBoundShopMenuOpenPacket(ShopInfo shop, List<ShopItemInfo> items) {
        this.shop = shop;
        this.items = items;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.shop.id());
        buffer.m_130070_(this.shop.name());
        buffer.m_130070_(this.shop.description());
        buffer.writeInt(this.items.size());
        for (ShopItemInfo item : this.items) {
            buffer.writeInt(item.itemId());
            buffer.m_130070_(item.itemName());
            buffer.m_130070_(item.itemDescription());
            buffer.m_130070_(item.modItemName());
            buffer.writeInt(item.shopItemId());
            buffer.m_130070_(item.price());
            buffer.writeBoolean(item.inStock());
        }
    }

    public static ClientBoundShopMenuOpenPacket decode(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        String name = buffer.m_130277_();
        String description = buffer.m_130277_();
        ShopInfo shopInfo = new ShopInfo(id, name, description);
        int itemCount = buffer.readInt();
        ArrayList<ShopItemInfo> items = new ArrayList<ShopItemInfo>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            int itemId = buffer.readInt();
            String itemName = buffer.m_130277_();
            String itemDescription = buffer.m_130277_();
            String modItemName = buffer.m_130277_();
            int shopItemId = buffer.readInt();
            String price = buffer.m_130277_();
            boolean inStock = buffer.readBoolean();
            ShopItemInfo item = new ShopItemInfo(itemId, itemName, itemDescription, modItemName, shopItemId, price, inStock);
            items.add(item);
        }
        return new ClientBoundShopMenuOpenPacket(shopInfo, items);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ShopItemMenuScreen.showScreen(this.shop, this.items));
    }
}

