/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.registrationorganization.HorseRegistrationOrganizationSimple;
import com.equestricraft.mod.client.gui.horseregistration.HorseRegistrationPrompt;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.registration.HorseRegistrationOrganizationSerializer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundShowHorseRegistrationPromptPacket {
    private final int horseId;
    private final HorseRegistrationOrganizationSimple organization;

    public ClientBoundShowHorseRegistrationPromptPacket(int horseId, HorseRegistrationOrganizationSimple organization) {
        this.horseId = horseId;
        this.organization = organization;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        HorseRegistrationOrganizationSerializer.serialize(this.organization, buffer);
    }

    public static ClientBoundShowHorseRegistrationPromptPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        HorseRegistrationOrganizationSimple organization = HorseRegistrationOrganizationSerializer.deserialize(buffer);
        return new ClientBoundShowHorseRegistrationPromptPacket(horseId, organization);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseRegistrationPrompt.showScreen(this.horseId, this.organization));
    }
}

