/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.hud.HorseRidingHudElement;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundStaminaDisplayUpdatePacket {
    private final Integer percentage;
    private final boolean isLow;

    public ClientBoundStaminaDisplayUpdatePacket(Integer percentage, boolean isLow) {
        this.percentage = percentage;
        this.isLow = isLow;
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.percentage != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.percentage.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.writeBoolean(this.isLow);
    }

    public static ClientBoundStaminaDisplayUpdatePacket decode(FriendlyByteBuf buffer) {
        Integer percentage = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        boolean isLow = buffer.readBoolean();
        return new ClientBoundStaminaDisplayUpdatePacket(percentage, isLow);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> HorseRidingHudElement.setStaminaPercentage(this.percentage, this.isLow));
    }
}

