/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.horse.stud.HorseStudRegisterPage;
import com.equestricraft.core.horse.stud.HorseStudRegisterSortOrder;
import com.equestricraft.core.horse.stud.StudRegisterEntry;
import com.equestricraft.core.horse.stud.StudRegistrationStatus;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.studregistry.StudRegistrySimple;
import com.equestricraft.mod.client.gui.studregister.StudRegisterListScreen;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.PlayerSerializer;
import com.equestricraft.mod.studregistry.StudRegistrySerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundStudRegisterListOpenPacket {
    private final StudRegistrySimple registry;
    private final HorseStudRegisterPage page;

    public ClientBoundStudRegisterListOpenPacket(StudRegistrySimple registry, HorseStudRegisterPage page) {
        this.registry = registry;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        StudRegistrySerializer.serialize(this.registry, buffer);
        buffer.writeInt(this.page.getItems().size());
        for (StudRegisterEntry entry : this.page.getItems()) {
            buffer.writeInt(entry.registrationId());
            buffer.writeInt(entry.registryId());
            buffer.m_130070_(entry.registryName());
            if (entry.showName() != null) {
                buffer.writeBoolean(true);
                buffer.m_130070_(entry.showName());
            } else {
                buffer.writeBoolean(false);
            }
            PlayerSerializer.serializePlayerSimple(entry.owner(), buffer);
            buffer.m_130075_(entry.timeInitiallyRegistered());
            buffer.m_130075_(entry.timeLastRenewed());
            buffer.m_130075_(entry.expiryTime());
            buffer.m_130068_((Enum)entry.status());
        }
        buffer.m_130068_((Enum)this.page.getSortOrder());
        buffer.m_130068_((Enum)this.page.getSortDirection());
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
    }

    public static ClientBoundStudRegisterListOpenPacket decode(FriendlyByteBuf buffer) {
        StudRegistrySimple registry = StudRegistrySerializer.deserialize(buffer);
        int size = buffer.readInt();
        ArrayList<StudRegisterEntry> entries = new ArrayList<StudRegisterEntry>(size);
        for (int i = 0; i < size; ++i) {
            int registrationId = buffer.readInt();
            int groupId = buffer.readInt();
            String groupName = buffer.m_130277_();
            String showName = buffer.readBoolean() ? buffer.m_130277_() : null;
            PlayerSimple owner = PlayerSerializer.deserializePlayerSimple(buffer);
            Date timeInitiallyRegistered = buffer.m_130282_();
            Date timeLastRenewed = buffer.m_130282_();
            Date expiryTime = buffer.m_130282_();
            StudRegistrationStatus status = (StudRegistrationStatus)buffer.m_130066_(StudRegistrationStatus.class);
            StudRegisterEntry entry = new StudRegisterEntry(registrationId, groupId, groupName, showName, owner, timeInitiallyRegistered, timeLastRenewed, expiryTime, status);
            entries.add(entry);
        }
        HorseStudRegisterSortOrder sortOrder = (HorseStudRegisterSortOrder)buffer.m_130066_(HorseStudRegisterSortOrder.class);
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        HorseStudRegisterPage page = new HorseStudRegisterPage(entries, pageNumber, totalPages, sortDirection, sortOrder, null);
        return new ClientBoundStudRegisterListOpenPacket(registry, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> StudRegisterListScreen.showScreen(this.registry, this.page));
    }
}

