/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.player.tack.TackInventoryPage;
import com.equestricraft.core.player.tack.TackInventoryPageItem;
import com.equestricraft.mod.client.gui.tack.TackInventoryMenu;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundTackInventoryPageOpenPacket {
    private final int horseId;
    private final TackInventoryPage page;

    public ClientBoundTackInventoryPageOpenPacket(int horseId, TackInventoryPage page) {
        this.horseId = horseId;
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.horseId);
        buffer.writeInt(this.page.getItems().size());
        for (TackInventoryPageItem item : this.page.getItems()) {
            buffer.m_130077_(item.itemId());
            buffer.writeInt(item.id());
            buffer.m_130070_(item.name());
            buffer.writeDouble(item.condition());
        }
        buffer.writeInt(this.page.getPageNumber());
        buffer.writeInt(this.page.getTotalPages());
        buffer.m_130068_((Enum)this.page.getSortDirection());
    }

    public static ClientBoundTackInventoryPageOpenPacket decode(FriendlyByteBuf buffer) {
        int horseId = buffer.readInt();
        int amount = buffer.readInt();
        ArrayList<TackInventoryPageItem> items = new ArrayList<TackInventoryPageItem>(amount);
        for (int i = 0; i < amount; ++i) {
            UUID itemId = buffer.m_130259_();
            int id = buffer.readInt();
            String name = buffer.m_130277_();
            double condition = buffer.readDouble();
            TackInventoryPageItem item = new TackInventoryPageItem(itemId, id, name, condition);
            items.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        TackInventoryPage page = new TackInventoryPage((List<TackInventoryPageItem>)items, pageNumber, totalPages, sortDirection, (Object)null, (Object)null);
        return new ClientBoundTackInventoryPageOpenPacket(horseId, page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> TackInventoryMenu.showScreen(this.horseId, this.page));
    }
}

