/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.mod.client.ClientPrompt;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundTextPromptOpenPacket {
    private final UUID uuid;
    private final String title;
    private final String text;
    private final Integer minimumLength;
    private final Integer maximumLength;
    private final String defaultValue;

    public ClientBoundTextPromptOpenPacket(UUID uuid, String title, String text, Integer minimumLength, Integer maximumLength, String defaultValue) {
        this.uuid = uuid;
        this.title = title;
        this.text = text;
        this.minimumLength = minimumLength;
        this.maximumLength = maximumLength;
        this.defaultValue = defaultValue;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130070_(this.title);
        buffer.m_130070_(this.text);
        if (this.minimumLength != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.minimumLength.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.maximumLength != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.maximumLength.intValue());
        } else {
            buffer.writeBoolean(false);
        }
        if (this.defaultValue != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(this.defaultValue);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static ClientBoundTextPromptOpenPacket decode(FriendlyByteBuf buffer) {
        UUID uuid = buffer.m_130259_();
        String title = buffer.m_130277_();
        String text = buffer.m_130277_();
        Integer minimumLength = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        Integer maximumLength = buffer.readBoolean() ? Integer.valueOf(buffer.readInt()) : null;
        String defaultValue = buffer.readBoolean() ? buffer.m_130277_() : null;
        return new ClientBoundTextPromptOpenPacket(uuid, title, text, minimumLength, maximumLength, defaultValue);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> ClientPrompt.showTextPrompt(this.uuid, this.title, this.text, this.minimumLength, this.maximumLength, this.defaultValue));
    }
}

