/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.text.TextItem;
import com.equestricraft.mod.client.gui.ToastDisplay;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.util.ComponentUtil;
import com.equestricraft.mod.util.TextItemUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundToastSetPacket {
    private final TextItem message;

    public ClientBoundToastSetPacket(TextItem message) {
        this.message = message;
    }

    public void encode(FriendlyByteBuf buffer) {
        TextItemUtil.encode(buffer, this.message);
    }

    public static ClientBoundToastSetPacket decode(FriendlyByteBuf buffer) {
        TextItem message = TextItemUtil.decode(buffer);
        return new ClientBoundToastSetPacket(message);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> {
            TextComponent component = ComponentUtil.buildComponentFromTextItem(this.message);
            ToastDisplay.setMessage(component);
        });
    }
}

