/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.university.UniversityExamDto;
import com.equestricraft.core.university.module.questions.UniversityModuleQuestionDto;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.university.UniversityExamHandler;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundUniversityExamPacket {
    private final UniversityExamDto exam;

    public ClientBoundUniversityExamPacket(UniversityExamDto exam) {
        this.exam = exam;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.exam.moduleId());
        buffer.m_130070_(this.exam.moduleName());
        buffer.writeInt(this.exam.questions().size());
        for (UniversityModuleQuestionDto question : this.exam.questions()) {
            buffer.m_130077_(question.questionId());
            buffer.m_130070_(question.questionText());
            buffer.writeInt(question.questionAnswers().size());
            for (UniversityModuleQuestionDto.QuestionAnswer answer : question.questionAnswers()) {
                buffer.m_130070_(answer.text());
                buffer.writeBoolean(answer.correct());
            }
        }
    }

    public static ClientBoundUniversityExamPacket decode(FriendlyByteBuf buffer) {
        int moduleId = buffer.readInt();
        String moduleName = buffer.m_130277_();
        int questionsCount = buffer.readInt();
        ArrayList<UniversityModuleQuestionDto> questions = new ArrayList<UniversityModuleQuestionDto>(questionsCount);
        for (int i = 0; i < questionsCount; ++i) {
            UUID questionId = buffer.m_130259_();
            String questionText = buffer.m_130277_();
            int answerCount = buffer.readInt();
            ArrayList<UniversityModuleQuestionDto.QuestionAnswer> answers = new ArrayList<UniversityModuleQuestionDto.QuestionAnswer>(answerCount);
            for (int j = 0; j < answerCount; ++j) {
                String answerText = buffer.m_130277_();
                boolean correct = buffer.readBoolean();
                UniversityModuleQuestionDto.QuestionAnswer answer = new UniversityModuleQuestionDto.QuestionAnswer(answerText, correct);
                answers.add(answer);
            }
            UniversityModuleQuestionDto question = new UniversityModuleQuestionDto(questionId, questionText, answers);
            questions.add(question);
        }
        UniversityExamDto exam = new UniversityExamDto(moduleId, moduleName, questions);
        return new ClientBoundUniversityExamPacket(exam);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> UniversityExamHandler.startExam(this.exam));
    }
}

