/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.weather.CurrentWeather;
import com.equestricraft.mod.client.weather.WeatherController;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.weather.WeatherSerializer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundWeatherChangePacket {
    private final CurrentWeather currentWeather;

    public ClientBoundWeatherChangePacket(CurrentWeather currentWeather) {
        this.currentWeather = currentWeather;
    }

    public void encode(FriendlyByteBuf buffer) {
        WeatherSerializer.encodeCurrentWeather(this.currentWeather, buffer);
    }

    public static ClientBoundWeatherChangePacket decode(FriendlyByteBuf buffer) {
        CurrentWeather currentWeather = WeatherSerializer.decodeCurrentWeather(buffer);
        return new ClientBoundWeatherChangePacket(currentWeather);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> {
            WeatherController controller = WeatherController.getInstance();
            controller.updateWeather(this.currentWeather);
        });
    }
}

