/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.core.weather.WeatherForecastInfo;
import com.equestricraft.core.weather.WeatherType;
import com.equestricraft.mod.client.gui.weather.WeatherForecastMenu;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.weather.WeatherForecastMenuPage;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundWeatherForecastMenuOpenPacket {
    private final WeatherForecastMenuPage page;

    public ClientBoundWeatherForecastMenuOpenPacket(WeatherForecastMenuPage page) {
        this.page = page;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130075_(this.page.date());
        buffer.writeInt(this.page.currentOffset());
        WeatherForecastInfo forecast = this.page.forecast();
        buffer.writeInt(forecast.weatherTypes().size());
        for (WeatherType type : forecast.weatherTypes()) {
            buffer.m_130068_((Enum)type);
        }
        buffer.writeInt(forecast.minimumTemperature());
        buffer.writeInt(forecast.maximumTemperature());
        buffer.m_130070_(forecast.minimumTemperatureFormatted());
        buffer.m_130070_(forecast.maximumTemperatureFormatted());
        buffer.writeInt(forecast.minimumWindSpeed());
        buffer.writeInt(forecast.maximumWindSpeed());
        buffer.m_130070_(forecast.minimumWindSpeedFormatted());
        buffer.m_130070_(forecast.maximumWindSpeedFormatted());
        buffer.writeBoolean(forecast.freezing());
        buffer.writeBoolean(forecast.snowing());
        buffer.writeBoolean(forecast.thunder());
        buffer.writeBoolean(forecast.heatwave());
        buffer.writeBoolean(forecast.highWinds());
        buffer.writeBoolean(forecast.fog());
        buffer.m_130070_(this.page.description());
        buffer.writeBoolean(this.page.hasPrevious());
        buffer.writeBoolean(this.page.hasNext());
    }

    public static ClientBoundWeatherForecastMenuOpenPacket decode(FriendlyByteBuf buffer) {
        Date date = buffer.m_130282_();
        int currentOffset = buffer.readInt();
        int typesCount = buffer.readInt();
        ArrayList<WeatherType> types = new ArrayList<WeatherType>(typesCount);
        for (int i = 0; i < typesCount; ++i) {
            WeatherType type = (WeatherType)buffer.m_130066_(WeatherType.class);
            types.add(type);
        }
        int minimumTemperature = buffer.readInt();
        int maximumTemperature = buffer.readInt();
        String minimumTemperatureFormatted = buffer.m_130277_();
        String maximumTemperatureFormatted = buffer.m_130277_();
        int minimumWindSpeed = buffer.readInt();
        int maximumWindSpeed = buffer.readInt();
        String minimumWindSpeedFormatted = buffer.m_130277_();
        String maximumWindSpeedFormatted = buffer.m_130277_();
        boolean freezing = buffer.readBoolean();
        boolean snowing = buffer.readBoolean();
        boolean thunder = buffer.readBoolean();
        boolean heatwave = buffer.readBoolean();
        boolean highWinds = buffer.readBoolean();
        boolean fog = buffer.readBoolean();
        WeatherForecastInfo forecast = new WeatherForecastInfo(types, minimumTemperature, maximumTemperature, minimumTemperatureFormatted, maximumTemperatureFormatted, minimumWindSpeed, maximumWindSpeed, minimumWindSpeedFormatted, maximumWindSpeedFormatted, freezing, snowing, thunder, heatwave, highWinds, fog);
        String description = buffer.m_130277_();
        boolean hasPrevious = buffer.readBoolean();
        boolean hasNext = buffer.readBoolean();
        WeatherForecastMenuPage page = new WeatherForecastMenuPage(date, currentOffset, forecast, description, hasPrevious, hasNext);
        return new ClientBoundWeatherForecastMenuOpenPacket(page);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleClientPacket(context, () -> WeatherForecastMenu.showMenu(this.page));
    }
}

