/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.context.Context;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketUtil {
    private static final Log log = Log.getLogger(PacketUtil.class.getName());

    public static boolean handleServerPacket(Supplier<NetworkEvent.Context> context, Consumer<OnlinePlayer> handler) {
        AtomicBoolean success = new AtomicBoolean(false);
        NetworkEvent.Context c = context.get();
        c.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            try {
                ServerPlayer player = Objects.requireNonNull(c.getSender());
                ECPlayer onlinePlayer = OnlinePlayerCache.getInstance().requirePlayer(player.m_142081_());
                Context.wrapInContext(onlinePlayer, () -> handler.accept(onlinePlayer.require(OnlinePlayer.class)));
                success.set(true);
            }
            catch (Exception ex) {
                log.error("Error", ex);
                success.set(false);
            }
        }));
        c.setPacketHandled(true);
        return success.get();
    }

    public static boolean handleServerPacketAsync(Supplier<NetworkEvent.Context> context, Consumer<OnlinePlayer> handler) {
        AtomicBoolean success = new AtomicBoolean(false);
        NetworkEvent.Context c = context.get();
        c.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> {
            try {
                ServerPlayer serverPlayer = Objects.requireNonNull(c.getSender());
                ECPlayer player = OnlinePlayerCache.getInstance().requirePlayer(serverPlayer.m_142081_());
                TaskScheduler.executeAsyncTask(() -> Context.wrapInContext(player, () -> handler.accept(player.require(OnlinePlayer.class))));
                success.set(true);
            }
            catch (Exception ex) {
                log.error("Error", ex);
                success.set(false);
            }
        }));
        c.setPacketHandled(true);
        return success.get();
    }

    public static boolean handleClientPacket(Supplier<NetworkEvent.Context> context, Runnable handler) {
        AtomicBoolean success = new AtomicBoolean(false);
        NetworkEvent.Context c = context.get();
        c.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                handler.run();
                success.set(true);
            }
            catch (Exception ex) {
                log.error("Error", ex);
                success.set(false);
            }
        }));
        c.setPacketHandled(true);
        return success.get();
    }

    public static boolean handleClientPacketAsync(Supplier<NetworkEvent.Context> context, Runnable handler) {
        AtomicBoolean success = new AtomicBoolean(false);
        NetworkEvent.Context c = context.get();
        c.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            try {
                TaskScheduler.executeAsyncTask(handler);
                success.set(true);
            }
            catch (Exception ex) {
                log.error("Error", ex);
                success.set(false);
            }
        }));
        c.setPacketHandled(true);
        return success.get();
    }

    private PacketUtil() {
    }
}

