/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.economy.BankService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundBankAccountRenameAccountRequestPacket {
    private final int accountId;

    public ServerBoundBankAccountRenameAccountRequestPacket(int accountId) {
        this.accountId = accountId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.accountId);
    }

    public static ServerBoundBankAccountRenameAccountRequestPacket decode(FriendlyByteBuf buffer) {
        int accountId = buffer.readInt();
        return new ServerBoundBankAccountRenameAccountRequestPacket(accountId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            BankService service = Services.getService(BankService.class);
            Response r = service.renameAccount((OnlinePlayer)p, this.accountId);
            p.showResponse(r);
        });
    }
}

