/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Services;
import com.equestricraft.mod.economy.BankAccountTransactionSortOrder;
import com.equestricraft.mod.economy.BankService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundBankAccountTransactionScreenRequestPacket {
    private final int accountId;
    private final int pageNumber;
    private final SortDirection sortDirection;
    private final BankAccountTransactionSortOrder sortOrder;
    private final String text;

    public ServerBoundBankAccountTransactionScreenRequestPacket(int accountId, int pageNumber, SortDirection sortDirection, BankAccountTransactionSortOrder sortOrder, String text) {
        this.accountId = accountId;
        this.pageNumber = pageNumber;
        this.sortDirection = sortDirection;
        this.sortOrder = sortOrder;
        this.text = text;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.accountId);
        buffer.writeInt(this.pageNumber);
        buffer.m_130068_((Enum)this.sortDirection);
        buffer.m_130068_((Enum)this.sortOrder);
        buffer.m_130070_(this.text);
    }

    public static ServerBoundBankAccountTransactionScreenRequestPacket decode(FriendlyByteBuf buffer) {
        int accountId = buffer.readInt();
        int pageNumber = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        BankAccountTransactionSortOrder sortOrder = (BankAccountTransactionSortOrder)buffer.m_130066_(BankAccountTransactionSortOrder.class);
        String text = buffer.m_130277_();
        return new ServerBoundBankAccountTransactionScreenRequestPacket(accountId, pageNumber, sortDirection, sortOrder, text);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            BankService service = Services.getService(BankService.class);
            service.showBankAccountTransactionsMenuToPlayer((OnlinePlayer)p, this.accountId, this.pageNumber, this.sortDirection, this.sortOrder, this.text);
        });
    }
}

