/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.breed.BreedService;
import com.equestricraft.mod.packet.PacketUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundBreedInfoRequestPacket {
    private final int breedId;

    public ServerBoundBreedInfoRequestPacket(int breedId) {
        this.breedId = breedId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.breedId);
    }

    public static ServerBoundBreedInfoRequestPacket decode(FriendlyByteBuf buffer) {
        int breedId = buffer.readInt();
        return new ServerBoundBreedInfoRequestPacket(breedId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            BreedService service = Services.getService(BreedService.class);
            service.showBreedInfo((ECPlayer)p, this.breedId);
        });
    }
}

