/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.bulletin.BulletinService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundBulletinClosedPacket {
    private final int bulletinId;

    public ServerBoundBulletinClosedPacket(int bulletinId) {
        this.bulletinId = bulletinId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.bulletinId);
    }

    public static ServerBoundBulletinClosedPacket decode(FriendlyByteBuf buffer) {
        int bulletinId = buffer.readInt();
        return new ServerBoundBulletinClosedPacket(bulletinId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            BulletinService service = Services.getService(BulletinService.class);
            service.bulletinSeenByPlayer((OnlinePlayer)p, this.bulletinId);
        });
    }
}

