/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.packet;

import com.equestricraft.cdi.Services;
import com.equestricraft.mod.bulletin.BulletinService;
import com.equestricraft.mod.packet.PacketUtil;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundBulletinNextPacket {
    private final int bulletinId;

    public ServerBoundBulletinNextPacket(int bulletinId) {
        this.bulletinId = bulletinId;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.bulletinId);
    }

    public static ServerBoundBulletinNextPacket decode(FriendlyByteBuf buffer) {
        int bulletinId = buffer.readInt();
        return new ServerBoundBulletinNextPacket(bulletinId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        return PacketUtil.handleServerPacketAsync(context, p -> {
            BulletinService service = Services.getService(BulletinService.class);
            service.nextBulletin((OnlinePlayer)p, this.bulletinId);
        });
    }
}

